function StartStart::onEnter(%this)
{
   tsNameObj("Wilkins", "Evan Wilkins");
   tsNameObj("Logan", "Logan James");
   
   //Resetting Tutorial Settings.
   tsEnableCommand(DemolishCmdData, true);
   tsEnableCommand(RepairCmdData, true);
   
   LogcabinButton.disabled = true;
   
   //Re-enabling XPBuy.
   //Buildings
   XPBuyChurch.reqCheck0 = true;
   XPBuyWindmill.reqCheck0 = true;
   XPBuyTradingPost.reqCheck0 = true;
   XPBuyWatchTower.reqCheck0 = true;
   XPBuySaloon.reqCheck0 = true;
   XPBuyGeneral.reqCheck0 = true;
   XPBuyGranary.reqCheck0 = true;
   XPBuyBarberShop.reqCheck0 = true;
   XPBuyOuthouse.reqCheck0 = true;
   XPBuyGazebo.reqCheck0 = true;
   XPBuySaloon.reqCheck0 = true;
   XPBuySheriffsOffice.reqCheck0 = true;
   XPBuyFountain.reqCheck0 = true;
   XPBuyWatertower.reqCheck0 = true;
   XPBuyFlowerpot.reqCheck0 = true;
   XPBuyLumbermill.reqCheck0 = true;
   XPBuyBlacksmith.reqCheck0 = true;
   XPBuyRanch.reqCheck0 = true;
   XPBuyWelcome.reqCheck0 = true;
   
   //Upgrades
   XPBuyCorn.reqCheck0 = true;
   XPBuyPumpkins.reqCheck0 = true;
   
   // Turn on Behavior
   $AI_MONITORJOB     = true;
   $AI_MONITORHOME    = true;
   $AI_MONITORHUNGER  = true;
   
   GameCamera.FlySpeed = 75;
   TaskModifier.strMarkVertex("StartTasks", "StartStart", $TSV_CMPLETE);
   
   // Start Main Map Tutorial Tasks
   TaskModifier.strMarkVertex("StartTasks", "MyWoodhut", $TSV_AVAIL);
   TaskModifier.strMarkVertex("StartTasks", "HappyTutorialTrigger", $TSV_AVAIL);
   TaskModifier.strMarkVertex("StartTasks", "Coveredgoldmine", $TSV_AVAIL);
   
   TaskModifier.strMarkVertex("MainmapTasks", "FoodLowTrigger", $TSV_AVAIL);
   TaskModifier.strMarkVertex("MainmapTasks", "PlatformTriggerZone", $TSV_AVAIL);
   TaskModifier.strMarkVertex("MainmapTasks", "BadSeedMapTrigger", $TSV_AVAIL);
   TaskModifier.strMarkVertex("MainmapTasks", "BridgetutTrigger", $TSV_AVAIL);
   
   //Start NPC animations
   DMworker.playThread(0, "repair");
}

function StartIntro::onEnter(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTSTART", false, false, "ID_STARTSTART");
   tsAddTaskDialog("ID_STARTSTART", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   TaskModifier.strMarkVertex("StartTasks", "StartIntro", $TSV_CMPLETE);
}

////////////////////////////////////////////////////////////
// Covered Goldmine hint
////////////////////////////////////////////////////////////

// Triggers when a team 1 unit walks into zone: goldminerock
function Coveredgoldmine::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_Task_Coveredgoldmine", false, false, "ID_hiddengold");
   tsAddTaskDialog("ID_hiddengold", %dlgData);
   tsSendTaskDlgMsg(%dlgData, hiddengoldvein.getID());
   tsDestroyTaskDlgData(%dlgData);
}

////////////////////////////////////////////////////////////
// Not Your Wood HUT 
////////////////////////////////////////////////////////////

function MyWoodhut::onExit(%this)
{
   if(!(WoodComplete.isComplete() || WoodComplete.isMarkedComplete()))
   {
      %dlgData = tsCreateTaskDlgData("ID_NotYours",  false, $TaskButton::More, "ID_Mywoodhut");
      tsAddTaskDialog("ID_Mywoodhut", %dlgData);
      tsSendTaskDlgMsg(%dlgData, "WikWoodhut");
      tsDestroyTaskDlgData(%dlgData);
      %dlgData = tsCreateTaskDlgData("ID_NotYours",  false, false, "ID_Wilkinshut");
      tsAddTaskDialog("ID_Wilkinshut", %dlgData);
      tsSendTaskDlgMsg(%dlgData, "Wilkins");
      tsDestroyTaskDlgData(%dlgData);
   }
}
function MyWoodhutmove::onExit(%this)
{
   tsMoveCameraToObject("Wilkins", false);
   TaskModifier.strMarkVertex("StartTasks", "MyWoodhutmove", $TSV_CMPLETE);
}
function MyWoodhutback::onExit(%this)
{
   tsMoveCameraToObject("WikWoodhut", false);
}

////////////////////////////////////////////////////////////////////////////////
// Happiness Tutorial
////////////////////////////////////////////////////////////////////////////////

function HappyTutorialTrigger::onUpdate()
{   
   %resourceCount = rsGetResourceCount($Resource::People);
   
   if(%resourceCount >= 5)
   {
      TaskModifier.StrMarkVertex("StartTasks", "HappyTutorialTrigger", $TSV_CMPLETE);
      TaskModifier.StrMarkVertex("StartTasks", "HappyTutorialStart", $TSV_AVAIL);
      TaskModifier.StrMarkVertex("MainmapTasks", "JobhuntTrigger", $TSV_AVAIL);
   }
   
}
function HappyTutorialStart::onExit()
{   
   // Start Happiness Tutorial
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_HappyTut", false, $TaskButton::More, "ID_Happytutstart");
   tsAddTaskDialog("ID_Happytutstart", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   
   if(firstword(getRes()) > 800)
   {
      %imagePos = "18 63";
   }
   else
   {
      %imagePos = "14 49";
   }
   %image = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png";
      iconEnabled = "~/client/ui/hud/happinessicon3.png"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "127 65";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };   
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_HappyTut", false, $TaskButton::More, "ID_Happytutnext");
   tsAddTaskDialog("ID_Happytutnext", %dlgData);
   tsSetTaskDialogImage(%image, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_HappyTut", false, false, "ID_Happytutnext1");
   tsAddTaskDialog("ID_Happytutnext1", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
}

////////////////////////////////////////////////////////////
/////////////////// SECRET GOLDMINE ////////////////////////
////////////////////////////////////////////////////////////

function WoodStart::onEnter(%this)
{
   Parent::onEnter(%this);
}

function WoodStart::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   
}
function WoodStart::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTWOOD", true, false, "ID_WOODSTART");
   tsAddTaskDialog("ID_WOODSTART", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Wilkins");
   tsDestroyTaskDlgData(%dlgData);
}

function WoodExplain::onExit()
{

   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTWOOD", false, false, "ID_WOODEXPLAIN");
   tsAddTaskDialog("ID_WOODEXPLAIN", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Wilkins");
   tsDestroyTaskDlgData(%dlgData);
   // Quest log
   tsAddQuestToTracker(true, "My Mine", "", "Help Evan Wilkins gather up the Wood to repair his Wood Hut.", "Reward: Location of a hidden Mine.");
   tsReadyQuest("My Mine");
   tsAddTaskToTracker("My Mine", "Give 100 Wood to Evan Wilkins.", "Gather 100 Wood for Evan Wilkins.");
   // First time quest log tutorial
   if(!(QuestlogComplete.isMarkedComplete() || QuestlogComplete.isComplete()))
   {
      TaskModifier.strMarkVertex("StartTasks", "QuestlogIntro", $TSV_AVAIL);
      TaskModifier.strMarkVertex("StartTasks", "QuestlogComplete", $TSV_CMPLETE);
   }
}

function WoodGo::onExit()
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTWOOD", true, true, "ID_WOODGO");
   tsAddTaskDialog("ID_WOODGO", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsAddAcceptCost($Resource::Wood, 100, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Wilkins");
   tsDestroyTaskDlgData(%dlgData);
   // Quest Log
   tsAddTaskToTracker("My Mine", "Uncover Secret Gold Vein.", "Find the location of Evan's Secret Gold Vein.");

}

function WoodMine::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if(%this.isMarkedComplete())
   {      
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTWOOD", false, false, "ID_WOODMINE");
      tsAddTaskDialog("ID_WOODMINE", %dlgData);
      tsSendTaskDlgMsg(%dlgData, "Wilkins");
      tsDestroyTaskDlgData(%dlgData);
      tsRemoveObj("Rock1");
      tsCreateObj("goldvein", "secretgoldmine", $OST_NEUTRAL, "-350 -404");
      // Quest Log      
      tsCompleteTaskInTracker("My Mine", "Give 100 Wood to Evan Wilkins.");
   }
}

function WoodComplete::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if(%this.isMarkedComplete())
   {
      tsMoveCameraToObject("secretgoldmine", false);
   }
}

function WoodCompleteTwo::onExit(%this)
{
   Parent::onExit(%this); 
   tsMoveCameraToObject("Wilkins", false);   
   // Quest Log
   tsCompleteTaskInTracker("My Mine", "Uncover Secret Gold Vein.");
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
}

function WoodJoin::onExit(%this)
{   
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTWOOD", true, true, "ID_WOODJoin");
   tsAddTaskDialog("ID_WOODJoin", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_SURE", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Wilkins");
   tsDestroyTaskDlgData(%dlgData);
}
function WoodJoinAccept::onExit(%this)
{
   tsConvertObjTeam("Wilkins", $OST_PLAYER);
   tsSkinObj("Wilkins", "base");
   tsConvertObjTeam("WikWoodhut", $OST_PLAYER);
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTWOOD", false, false, "ID_WOODJoinAccept");
   tsAddTaskDialog("ID_WOODJoinAccept", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Wilkins");
   tsDestroyTaskDlgData(%dlgData);
   TaskModifier.strMarkVertex("StartTasks", "WoodJoinAccept", $TSV_CMPLETE);
}

////////////////////////////////////////////////////////////
/////////////////// FOOD AND FARM //////////////////////////
////////////////////////////////////////////////////////////

function FoodIntro::onExit(%this)
{
   tsMoveObjToTarget("Logan", "-392 -350");
}
function FoodStart::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTFOOD", true, false, "ID_FOODSTART");
   tsAddTaskDialog("ID_FOODSTART", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Logan");
   tsDestroyTaskDlgData(%dlgData);
}
function FoodExplain::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete())
   {
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTFOOD", false, false, "ID_FOODEXPLAIN");
      tsAddTaskDialog("ID_FOODEXPLAIN", %dlgData);
      tsSendTaskDlgMsg(%dlgData, "Logan");
      tsDestroyTaskDlgData(%dlgData);      
   }
}
function FoodAccept::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTFOOD", true, true, "ID_FOODAccept");
   tsAddTaskDialog("ID_FOODAccept", %dlgData);
    tsSetAcceptButtonText("ID_ACCEPT_SURE", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Logan");
   tsDestroyTaskDlgData(%dlgData);
}
function FoodAccept2::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTFOOD", false, false, "ID_FOODAccept2");
   tsAddTaskDialog("ID_FOODAccept2", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Logan");
   tsDestroyTaskDlgData(%dlgData);
   tsMoveObjToTarget("Logan", "-388 -291");
   %objList = tsCreateObjList();
   
   tsFindObjTypeOnMap("farm", "bldg", %objList);
   %index = %objList.getSize();
   tsDestroyObjList(%objList);
   if(%index > 0)
   {
      //Farm already exists
      TaskModifier.strMarkVertex("StartTasks", "FoodFarmBuilt", $TSV_CMPLETE);
      // Quest log
      tsAddQuestToTracker(true, "Food For Thought", "", "Gather 22 Food for Logan James to make up for his inability to grow his own.", "Reward: Unlock the Granary building.");
      tsReadyQuest("Food For Thought");
      tsAddTaskToTracker("Food For Thought", "Gather 22 Food.", "Gather 22 Food for Logan James.");
   }
   else
   {
      //Quest log
      tsAddQuestToTracker(true, "Food For Thought", "", "Gather 22 Food for Logan James to make up for his inability to grow his own.", "Reward: Unlock the Granary building.");
      tsReadyQuest("Food For Thought");
      tsAddTaskToTracker("Food For Thought", "Build a Farm.", "Build a Farm.");
      tsAddTaskToTracker("Food For Thought", "Gather 22 Food.", "Gather 22 Food for Logan James.");
   }
   // First time quest log tutorial
   if(!(QuestlogComplete.isMarkedComplete() || QuestlogComplete.isComplete()))
   {
      TaskModifier.strMarkVertex("StartTasks", "QuestlogIntro", $TSV_AVAIL);
      TaskModifier.strMarkVertex("StartTasks", "QuestlogComplete", $TSV_CMPLETE);
   }

}
function FoodFarmBuilt::onExit(%this)
{
   tsMoveObjToTarget("Logan", "-388 -291");
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTFOOD", false, false, "ID_FOODFarm");
   tsAddTaskDialog("ID_FOODFarm", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Logan");
   tsDestroyTaskDlgData(%dlgData);
   //Quest log
   tsCompleteTaskInTracker("Food For Thought", "Build a Farm.");
}
function FoodGo::onEnter(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTFOOD", true, true, "ID_FOODGO");
   tsAddTaskDialog("ID_FOODGO", %dlgData);
   tsAddAcceptCost($Resource::Food, 22, %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Logan");
   tsDestroyTaskDlgData(%dlgData);
   
   //Complete Vertex
   TaskModifier.strMarkVertex("StartTasks", "FoodGo", $TSV_CMPLETE);
}

function FoodDone::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete())
   {
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTFOOD", false, false, "ID_FOODDONE");
      tsAddTaskDialog("ID_FOODDONE", %dlgData);
      tsSendTaskDlgMsg(%dlgData, "Logan");
      tsDestroyTaskDlgData(%dlgData);
      tsActivateBuildingXP("Granary"); // Unlock Granary
      
      // Quest log
      tsAddTaskToTracker("Food For Thought", "", "You can now build Granaries to store more Food.");
      tsCompleteTaskInTracker("Food For Thought", "Gather 22 Food.");
      
      // Reward
      tsModifyResource($Resource::Experience, 5, true);
      SendProductionToClient(HeroCharacter, "5 experience");      
   }
}

function FoodMoveLogan::onExit(%this)
{
   tsMoveObjToTarget("Logan", "-440 -280");
}
// End Vertex
function FoodComplete::onExit(%this)
{
   tsRemoveObj("Logan");
}

////////////////////////////////////////////////////////////
///////////////// LogCabin Unlock //////////////////////////
////////////////////////////////////////////////////////////

function GoldStart::onExit(%this)
{
   tsCreateObj("MaleCiv", "Fremont", "0", "-464 -280", "Fremont");
   tsNameObj("Fremont", "Fremont Auren");
   tsSkinObj("Fremont", "default");
}
// Vertex completes when Fremont is created
function MoveFremont::onExit(%this)
{      
   tsMoveObjToTarget("Fremont", "-387 -303");
}
function GoldExplain::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTGOLD", true, false, "ID_GOLDEXPLAIN");
   tsAddTaskDialog("ID_GOLDEXPLAIN", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Fremont");
   tsDestroyTaskDlgData(%dlgData);
}

function GoldDelay::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTGOLD", false, false, "ID_GOLDEXPLAIN2");
   tsAddTaskDialog("ID_GOLDEXPLAIN2", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Fremont");
   tsDestroyTaskDlgData(%dlgData);
   // Quest Log
   tsAddQuestToTracker(true, "A Golden Opportunity", "", "Give Fremont Auren 100 Gold to pay off his sister's debt.", "Reward: Plans for a Log Cabin to improve the quality of life in town.");
   tsReadyQuest("A Golden Opportunity");
   tsAddTaskToTracker("A Golden Opportunity", "Give 100 Gold to Fremont.", "Gather 100 Gold for Fremont Auren.");

   // First time quest log tutorial
   if(!(QuestlogComplete.isMarkedComplete() || QuestlogComplete.isComplete()))
   {
      TaskModifier.strMarkVertex("StartTasks", "QuestlogIntro", $TSV_AVAIL);
      TaskModifier.strMarkVertex("StartTasks", "QuestlogComplete", $TSV_CMPLETE);
   }
}

function GoldGo::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTGOLD", true, true, "ID_GOLDGO");
   tsAddTaskDialog("ID_GOLDGO", %dlgData);
   tsAddAcceptCost($Resource::Gold, 100, %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_SURE", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Fremont");
   tsDestroyTaskDlgData(%dlgData);

   //TaskModifier.strMarkVertex("StartTasks", "GoldGo", $TSV_CMPLETE);
}

function GoldUnlock::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete())
   {
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTGOLD", false, false, "ID_GOLDUNLOCK");
      tsAddTaskDialog("ID_GOLDUNLOCK", %dlgData);
      tsSendTaskDlgMsg(%dlgData, "Fremont");
      tsDestroyTaskDlgData(%dlgData);
      LogCabinButton.disabled=false;
      
      // Remove Fremont
      tsRemoveObj("Fremont");
      
      // Quest log
      tsAddTaskToTracker("A Golden Opportunity", "Build a Log Cabin.", "Build a Log Cabin for Fremont's sister to live in.");
      tsCompleteTaskInTracker("A Golden Opportunity", "Give 100 Gold to Fremont.");      
   }
}
// Vertex completes when player builds a logcabin
function GoldCabin::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete())
   {
      // Get cabin id
      %objList = tsCreateObjList();
      tsFindObjTypeOnMap("logcabin", "bldg", %objList);
      for(%index = 0; %index < %objList.getSize(); %index++)
      {
         %object = %objList.getID(%index);
         if(%object.getTeam() == "1")
         {
            %object = %objList.getID(%index);
         }
      }      
      tsDestroyObjList(%objList); // Destroy object list
      // Create units and move them to cabin
      tsCreateObj("FemaleCiv", "Anistacia", $OST_PLAYER, "-441 -280", "Anistacia");
      tsNameObj("Anistacia", "Anistacia Auren");
      tsCreateObj("MaleCiv", "Fremont2", $OST_PLAYER, "-439 -282", "Fremont2");
      tsNameObj("Fremont2", "Fremont Auren");
      tsMoveObjToTarget("Anistacia", %object);
      tsMoveObjToTarget("Fremont2", %object);
      
      TaskModifier.strMarkVertex("StartTasks", "GoldCabin", $TSV_CMPLETE);
      // Quest log
      tsAddTaskToTracker("A Golden Opportunity", "", "Enjoy comfortable housing with your Log Cabins.");
      tsCompleteTaskInTracker("A Golden Opportunity", "Build a Log Cabin.");
   }
}

// End Vertex
function GoldComplete::onExit(%this)
{   
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_STARTGOLD", false, false, "ID_GOLDCOMPLETE");
   tsAddTaskDialog("ID_GOLDCOMPLETE", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Anistacia");
   tsDestroyTaskDlgData(%dlgData);
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience"); 
}

////////////////////////////////////////////////////////////
///////////////// Quest Log Tutorial ///////////////////////
////////////////////////////////////////////////////////////

function QuestlogIntro::onExit(%this)
{   
   
   if(firstword(getRes()) > 800)
   {
      %imagePos = "22 71";
      %image1Pos = "21 63";
   }
   else
   {
      %imagePos = "17 55";
      %image1Pos = "17 49";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutquesticon.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "121 77";
      position = %image1Pos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_Questlog", false, $TaskButton::More, "ID_QuestIcon");
   tsAddTaskDialog("ID_QuestIcon", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   %image = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutquestbutton.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "108 76";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_Questlog", false, false, "ID_QuestPage");
   tsAddTaskDialog("ID_QuestPage", %dlgData);
   tsSetTaskDialogImage(%image, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
}

////////////////////////////////////////////////////////////
// Hoperiver refugees start
////////////////////////////////////////////////////////////

function HopeRefugeeStart::onExit(%this)
{
   // Start Hope River Refugees
   TaskModifier.strMarkVertex("MainmapTasks", "HopeRefugeesIntro", $TSV_AVAIL);
   TaskModifier.strMarkVertex("StartTasks", "HopeRefugeeStart", $TSV_CMPLETE);
   StartDisastersVeryLow();
}

////////////////////////////////////////////////////////////////////////////////
// Disasters Very Low
////////////////////////////////////////////////////////////////////////////////

//Turn on Disasters 
function StartDisastersVeryLow()
{   

   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 120 1"; 
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "0 120"; //0
      disasterDroughtRate = "10 160";
      disasterEarthquakeRate = "10 160";
      disasterFamineRate = "10 160";
      disasterFireRate = "0 200";
      disasterPlagueRate = "10 160";
      disasterTornadoRate = "10 200";
      
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 0; //0
      duration = 1000;

      fadeTime = 1;
      goldMin = 0;
      goldMax = 100;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 1;
      highCount = 2;

      happinessCount = -25;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 10;
      addRequirement = well;
      duration = 45;
      
      cost = 0.5;
   };
   
   // update the earthquake scenario
   %scenario.disasterEarthquakeScenario = new SLEarthquakeScenario()
   {
      chance = 10;
      duration = 5;
      
      shakeDistance = 0.4;
      damageLow = 15;
      damageHigh = 20;
   };
   
   // update the famine scenario
   %scenario.disasterFamineScenario = new SLFamineScenario()
   {
      chance = 15;
      //addRequirement = Granary;
      duration = 0;
      
      resource = $Resource::Food;
      cost = 0.20;
   };
      
   // update the plague scenario
   %scenario.disasterPlagueScenario = new SLPlagueScenario()
   {
      chance = 20;
      addRequirement = Farm;
      addRequirement = Ranch;
      duration = 30;
      
      produceRate = 0.30;
      addProduce = "wheat";
      addProduce = "corn";
      addProduce = "pumpkin";
      addProduce = "chicken";
      addProduce = "pig";
      addProduce = "cow";
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 12;
      duration = 50;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 20;
   };
   
   LoadScenario(%scenario);
}